/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.animation;

public class ParallelAnimation extends CompositeAnimation {
	long updateDuration(long delay) {
		long duration = 0;
		for (int i = 0; i < childCount; i++) {
			Animation a = animations[i];
			duration = Math.max(a.updateDuration(delay), duration);
		}
		return delay+beginTime+duration;
	}
}
